package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecAdvancedSettingsPrefetch private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  allExtensions: Output[Boolean],
  configId: Output[Int],
  enableAppLayer: Output[Boolean],
  enableRateControls: Output[Boolean],
  extensions: Output[scala.collection.immutable.List[String]]
) extends CustomResource derives ResourceDecoder

object AppSecAdvancedSettingsPrefetch:
  given outputOps: {} with
    extension(output: Output[AppSecAdvancedSettingsPrefetch])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def allExtensions: Output[Boolean] = output.flatMap(_.allExtensions)
      def configId: Output[Int] = output.flatMap(_.configId)
      def enableAppLayer: Output[Boolean] = output.flatMap(_.enableAppLayer)
      def enableRateControls: Output[Boolean] = output.flatMap(_.enableRateControls)
      def extensions: Output[scala.collection.immutable.List[String]] = output.flatMap(_.extensions)

def appSecAdvancedSettingsPrefetch(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecAdvancedSettingsPrefetchArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecAdvancedSettingsPrefetch] = 
  ctx.registerResource[AppSecAdvancedSettingsPrefetch, AppSecAdvancedSettingsPrefetchArgs]("akamai:index/appSecAdvancedSettingsPrefetch:AppSecAdvancedSettingsPrefetch", name, args, opts)

