package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecAdvancedSettingsPrefetchArgs private(
  allExtensions: Output[Boolean],
  configId: Output[Int],
  enableAppLayer: Output[Boolean],
  enableRateControls: Output[Boolean],
  extensions: Output[scala.collection.immutable.List[String]]
) derives ArgsEncoder

object AppSecAdvancedSettingsPrefetchArgs:
  def apply(
    allExtensions: Input[Boolean],
    configId: Input[Int],
    enableAppLayer: Input[Boolean],
    enableRateControls: Input[Boolean],
    extensions: Input[List[Input[String]]]
  )(using Context): AppSecAdvancedSettingsPrefetchArgs =
    new AppSecAdvancedSettingsPrefetchArgs(
      allExtensions = allExtensions.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      enableAppLayer = enableAppLayer.asOutput(isSecret = false),
      enableRateControls = enableRateControls.asOutput(isSecret = false),
      extensions = extensions.asOutput(isSecret = false)
    )
