package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecApiConstraintsProtectionArgs private(
  configId: Output[Int],
  enabled: Output[Boolean],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecApiConstraintsProtectionArgs:
  def apply(
    configId: Input[Int],
    enabled: Input[Boolean],
    securityPolicyId: Input[String]
  )(using Context): AppSecApiConstraintsProtectionArgs =
    new AppSecApiConstraintsProtectionArgs(
      configId = configId.asOutput(isSecret = false),
      enabled = enabled.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
