package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecApiRequestConstraints private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  action: Output[String],
  apiEndpointId: Output[Option[Int]],
  configId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecApiRequestConstraints:
  given outputOps: {} with
    extension(output: Output[AppSecApiRequestConstraints])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def action: Output[String] = output.flatMap(_.action)
      def apiEndpointId: Output[Option[Int]] = output.flatMap(_.apiEndpointId)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecApiRequestConstraints(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecApiRequestConstraintsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecApiRequestConstraints] = 
  ctx.registerResource[AppSecApiRequestConstraints, AppSecApiRequestConstraintsArgs]("akamai:index/appSecApiRequestConstraints:AppSecApiRequestConstraints", name, args, opts)

