package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecApiRequestConstraintsArgs private(
  action: Output[String],
  apiEndpointId: Output[Option[Int]],
  configId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecApiRequestConstraintsArgs:
  def apply(
    action: Input[String],
    apiEndpointId: Input.Optional[Int] = None,
    configId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecApiRequestConstraintsArgs =
    new AppSecApiRequestConstraintsArgs(
      action = action.asOutput(isSecret = false),
      apiEndpointId = apiEndpointId.asOptionOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
