package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecAttackGroup private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  attackGroup: Output[String],
  attackGroupAction: Output[String],
  conditionException: Output[Option[String]],
  configId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecAttackGroup:
  given outputOps: {} with
    extension(output: Output[AppSecAttackGroup])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def attackGroup: Output[String] = output.flatMap(_.attackGroup)
      def attackGroupAction: Output[String] = output.flatMap(_.attackGroupAction)
      def conditionException: Output[Option[String]] = output.flatMap(_.conditionException)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecAttackGroup(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecAttackGroupArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecAttackGroup] = 
  ctx.registerResource[AppSecAttackGroup, AppSecAttackGroupArgs]("akamai:index/appSecAttackGroup:AppSecAttackGroup", name, args, opts)

