package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecByPassNetworkList private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  bypassNetworkLists: Output[scala.collection.immutable.List[String]],
  configId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecByPassNetworkList:
  given outputOps: {} with
    extension(output: Output[AppSecByPassNetworkList])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def bypassNetworkLists: Output[scala.collection.immutable.List[String]] = output.flatMap(_.bypassNetworkLists)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecByPassNetworkList(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecByPassNetworkListArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecByPassNetworkList] = 
  ctx.registerResource[AppSecByPassNetworkList, AppSecByPassNetworkListArgs]("akamai:index/appSecByPassNetworkList:AppSecByPassNetworkList", name, args, opts)

