package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecByPassNetworkListArgs private(
  bypassNetworkLists: Output[scala.collection.immutable.List[String]],
  configId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecByPassNetworkListArgs:
  def apply(
    bypassNetworkLists: Input[List[Input[String]]],
    configId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecByPassNetworkListArgs =
    new AppSecByPassNetworkListArgs(
      bypassNetworkLists = bypassNetworkLists.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
