package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecConfiguration private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  contractId: Output[String],
  createFromConfigId: Output[Option[Int]],
  createFromVersion: Output[Option[Int]],
  description: Output[String],
  groupId: Output[Int],
  hostNames: Output[scala.collection.immutable.List[String]],
  name: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecConfiguration:
  given outputOps: {} with
    extension(output: Output[AppSecConfiguration])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def contractId: Output[String] = output.flatMap(_.contractId)
      def createFromConfigId: Output[Option[Int]] = output.flatMap(_.createFromConfigId)
      def createFromVersion: Output[Option[Int]] = output.flatMap(_.createFromVersion)
      def description: Output[String] = output.flatMap(_.description)
      def groupId: Output[Int] = output.flatMap(_.groupId)
      def hostNames: Output[scala.collection.immutable.List[String]] = output.flatMap(_.hostNames)
      def name: Output[String] = output.flatMap(_.name)

def appSecConfiguration(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecConfigurationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecConfiguration] = 
  ctx.registerResource[AppSecConfiguration, AppSecConfigurationArgs]("akamai:index/appSecConfiguration:AppSecConfiguration", name, args, opts)

