package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecConfigurationArgs private(
  contractId: Output[String],
  createFromConfigId: Output[Option[Int]],
  createFromVersion: Output[Option[Int]],
  description: Output[String],
  groupId: Output[Int],
  hostNames: Output[scala.collection.immutable.List[String]],
  name: Output[Option[String]]
) derives ArgsEncoder

object AppSecConfigurationArgs:
  def apply(
    contractId: Input[String],
    createFromConfigId: Input.Optional[Int] = None,
    createFromVersion: Input.Optional[Int] = None,
    description: Input[String],
    groupId: Input[Int],
    hostNames: Input[List[Input[String]]],
    name: Input.Optional[String] = None
  )(using Context): AppSecConfigurationArgs =
    new AppSecConfigurationArgs(
      contractId = contractId.asOutput(isSecret = false),
      createFromConfigId = createFromConfigId.asOptionOutput(isSecret = false),
      createFromVersion = createFromVersion.asOptionOutput(isSecret = false),
      description = description.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      hostNames = hostNames.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false)
    )
