package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecConfigurationRename private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  description: Output[String],
  name: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecConfigurationRename:
  given outputOps: {} with
    extension(output: Output[AppSecConfigurationRename])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def description: Output[String] = output.flatMap(_.description)
      def name: Output[String] = output.flatMap(_.name)

def appSecConfigurationRename(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecConfigurationRenameArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecConfigurationRename] = 
  ctx.registerResource[AppSecConfigurationRename, AppSecConfigurationRenameArgs]("akamai:index/appSecConfigurationRename:AppSecConfigurationRename", name, args, opts)

