package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecConfigurationRenameArgs private(
  configId: Output[Int],
  description: Output[String],
  name: Output[Option[String]]
) derives ArgsEncoder

object AppSecConfigurationRenameArgs:
  def apply(
    configId: Input[Int],
    description: Input[String],
    name: Input.Optional[String] = None
  )(using Context): AppSecConfigurationRenameArgs =
    new AppSecConfigurationRenameArgs(
      configId = configId.asOutput(isSecret = false),
      description = description.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false)
    )
