package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecCustomDeny private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  customDeny: Output[String],
  customDenyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecCustomDeny:
  given outputOps: {} with
    extension(output: Output[AppSecCustomDeny])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customDeny: Output[String] = output.flatMap(_.customDeny)
      def customDenyId: Output[String] = output.flatMap(_.customDenyId)

def appSecCustomDeny(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecCustomDenyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecCustomDeny] = 
  ctx.registerResource[AppSecCustomDeny, AppSecCustomDenyArgs]("akamai:index/appSecCustomDeny:AppSecCustomDeny", name, args, opts)

