package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecCustomDenyArgs private(
  configId: Output[Int],
  customDeny: Output[String]
) derives ArgsEncoder

object AppSecCustomDenyArgs:
  def apply(
    configId: Input[Int],
    customDeny: Input[String]
  )(using Context): AppSecCustomDenyArgs =
    new AppSecCustomDenyArgs(
      configId = configId.asOutput(isSecret = false),
      customDeny = customDeny.asOutput(isSecret = false)
    )
