package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecCustomRule private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  customRule: Output[String],
  customRuleId: Output[Int]
) extends CustomResource derives ResourceDecoder

object AppSecCustomRule:
  given outputOps: {} with
    extension(output: Output[AppSecCustomRule])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customRule: Output[String] = output.flatMap(_.customRule)
      def customRuleId: Output[Int] = output.flatMap(_.customRuleId)

def appSecCustomRule(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecCustomRuleArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecCustomRule] = 
  ctx.registerResource[AppSecCustomRule, AppSecCustomRuleArgs]("akamai:index/appSecCustomRule:AppSecCustomRule", name, args, opts)

