package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecCustomRuleAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  customRuleAction: Output[String],
  customRuleId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecCustomRuleAction:
  given outputOps: {} with
    extension(output: Output[AppSecCustomRuleAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def customRuleAction: Output[String] = output.flatMap(_.customRuleAction)
      def customRuleId: Output[Int] = output.flatMap(_.customRuleId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecCustomRuleAction(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecCustomRuleActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecCustomRuleAction] = 
  ctx.registerResource[AppSecCustomRuleAction, AppSecCustomRuleActionArgs]("akamai:index/appSecCustomRuleAction:AppSecCustomRuleAction", name, args, opts)

