package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecCustomRuleActionArgs private(
  configId: Output[Int],
  customRuleAction: Output[String],
  customRuleId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecCustomRuleActionArgs:
  def apply(
    configId: Input[Int],
    customRuleAction: Input[String],
    customRuleId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecCustomRuleActionArgs =
    new AppSecCustomRuleActionArgs(
      configId = configId.asOutput(isSecret = false),
      customRuleAction = customRuleAction.asOutput(isSecret = false),
      customRuleId = customRuleId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
