package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecCustomRuleArgs private(
  configId: Output[Int],
  customRule: Output[String]
) derives ArgsEncoder

object AppSecCustomRuleArgs:
  def apply(
    configId: Input[Int],
    customRule: Input[String]
  )(using Context): AppSecCustomRuleArgs =
    new AppSecCustomRuleArgs(
      configId = configId.asOutput(isSecret = false),
      customRule = customRule.asOutput(isSecret = false)
    )
