package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecEval private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  currentRuleset: Output[String],
  evalMode: Output[Option[String]],
  evalOperation: Output[String],
  evalStatus: Output[String],
  evaluatingRuleset: Output[String],
  expirationDate: Output[String],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecEval:
  given outputOps: {} with
    extension(output: Output[AppSecEval])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def currentRuleset: Output[String] = output.flatMap(_.currentRuleset)
      def evalMode: Output[Option[String]] = output.flatMap(_.evalMode)
      def evalOperation: Output[String] = output.flatMap(_.evalOperation)
      def evalStatus: Output[String] = output.flatMap(_.evalStatus)
      def evaluatingRuleset: Output[String] = output.flatMap(_.evaluatingRuleset)
      def expirationDate: Output[String] = output.flatMap(_.expirationDate)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecEval(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecEvalArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecEval] = 
  ctx.registerResource[AppSecEval, AppSecEvalArgs]("akamai:index/appSecEval:AppSecEval", name, args, opts)

