package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecEvalArgs private(
  configId: Output[Int],
  evalMode: Output[Option[String]],
  evalOperation: Output[String],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecEvalArgs:
  def apply(
    configId: Input[Int],
    evalMode: Input.Optional[String] = None,
    evalOperation: Input[String],
    securityPolicyId: Input[String]
  )(using Context): AppSecEvalArgs =
    new AppSecEvalArgs(
      configId = configId.asOutput(isSecret = false),
      evalMode = evalMode.asOptionOutput(isSecret = false),
      evalOperation = evalOperation.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
