package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecEvalGroupArgs private(
  attackGroup: Output[String],
  attackGroupAction: Output[String],
  conditionException: Output[Option[String]],
  configId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecEvalGroupArgs:
  def apply(
    attackGroup: Input[String],
    attackGroupAction: Input[String],
    conditionException: Input.Optional[String] = None,
    configId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecEvalGroupArgs =
    new AppSecEvalGroupArgs(
      attackGroup = attackGroup.asOutput(isSecret = false),
      attackGroupAction = attackGroupAction.asOutput(isSecret = false),
      conditionException = conditionException.asOptionOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
