package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecEvalPenaltyBox private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  penaltyBoxAction: Output[String],
  penaltyBoxProtection: Output[Boolean],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecEvalPenaltyBox:
  given outputOps: {} with
    extension(output: Output[AppSecEvalPenaltyBox])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def penaltyBoxAction: Output[String] = output.flatMap(_.penaltyBoxAction)
      def penaltyBoxProtection: Output[Boolean] = output.flatMap(_.penaltyBoxProtection)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecEvalPenaltyBox(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecEvalPenaltyBoxArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecEvalPenaltyBox] = 
  ctx.registerResource[AppSecEvalPenaltyBox, AppSecEvalPenaltyBoxArgs]("akamai:index/appSecEvalPenaltyBox:AppSecEvalPenaltyBox", name, args, opts)

