package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecEvalRule private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  conditionException: Output[Option[String]],
  configId: Output[Int],
  ruleAction: Output[String],
  ruleId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecEvalRule:
  given outputOps: {} with
    extension(output: Output[AppSecEvalRule])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def conditionException: Output[Option[String]] = output.flatMap(_.conditionException)
      def configId: Output[Int] = output.flatMap(_.configId)
      def ruleAction: Output[String] = output.flatMap(_.ruleAction)
      def ruleId: Output[Int] = output.flatMap(_.ruleId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecEvalRule(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecEvalRuleArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecEvalRule] = 
  ctx.registerResource[AppSecEvalRule, AppSecEvalRuleArgs]("akamai:index/appSecEvalRule:AppSecEvalRule", name, args, opts)

