package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecEvalRuleArgs private(
  conditionException: Output[Option[String]],
  configId: Output[Int],
  ruleAction: Output[String],
  ruleId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecEvalRuleArgs:
  def apply(
    conditionException: Input.Optional[String] = None,
    configId: Input[Int],
    ruleAction: Input[String],
    ruleId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecEvalRuleArgs =
    new AppSecEvalRuleArgs(
      conditionException = conditionException.asOptionOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      ruleAction = ruleAction.asOutput(isSecret = false),
      ruleId = ruleId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
