package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecIPGeo private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  exceptionIpNetworkLists: Output[Option[scala.collection.immutable.List[String]]],
  geoNetworkLists: Output[Option[scala.collection.immutable.List[String]]],
  ipNetworkLists: Output[Option[scala.collection.immutable.List[String]]],
  mode: Output[String],
  securityPolicyId: Output[String],
  ukraineGeoControlAction: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppSecIPGeo:
  given outputOps: {} with
    extension(output: Output[AppSecIPGeo])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def exceptionIpNetworkLists: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.exceptionIpNetworkLists)
      def geoNetworkLists: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.geoNetworkLists)
      def ipNetworkLists: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.ipNetworkLists)
      def mode: Output[String] = output.flatMap(_.mode)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def ukraineGeoControlAction: Output[Option[String]] = output.flatMap(_.ukraineGeoControlAction)

def appSecIPGeo(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecIPGeoArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecIPGeo] = 
  ctx.registerResource[AppSecIPGeo, AppSecIPGeoArgs]("akamai:index/appSecIPGeo:AppSecIPGeo", name, args, opts)

