package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecIPGeoArgs private(
  configId: Output[Int],
  exceptionIpNetworkLists: Output[Option[scala.collection.immutable.List[String]]],
  geoNetworkLists: Output[Option[scala.collection.immutable.List[String]]],
  ipNetworkLists: Output[Option[scala.collection.immutable.List[String]]],
  mode: Output[String],
  securityPolicyId: Output[String],
  ukraineGeoControlAction: Output[Option[String]]
) derives ArgsEncoder

object AppSecIPGeoArgs:
  def apply(
    configId: Input[Int],
    exceptionIpNetworkLists: Input.Optional[List[Input[String]]] = None,
    geoNetworkLists: Input.Optional[List[Input[String]]] = None,
    ipNetworkLists: Input.Optional[List[Input[String]]] = None,
    mode: Input[String],
    securityPolicyId: Input[String],
    ukraineGeoControlAction: Input.Optional[String] = None
  )(using Context): AppSecIPGeoArgs =
    new AppSecIPGeoArgs(
      configId = configId.asOutput(isSecret = false),
      exceptionIpNetworkLists = exceptionIpNetworkLists.asOptionOutput(isSecret = false),
      geoNetworkLists = geoNetworkLists.asOptionOutput(isSecret = false),
      ipNetworkLists = ipNetworkLists.asOptionOutput(isSecret = false),
      mode = mode.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false),
      ukraineGeoControlAction = ukraineGeoControlAction.asOptionOutput(isSecret = false)
    )
