package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecMalwarePolicy private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  malwarePolicy: Output[String],
  malwarePolicyId: Output[Int]
) extends CustomResource derives ResourceDecoder

object AppSecMalwarePolicy:
  given outputOps: {} with
    extension(output: Output[AppSecMalwarePolicy])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def malwarePolicy: Output[String] = output.flatMap(_.malwarePolicy)
      def malwarePolicyId: Output[Int] = output.flatMap(_.malwarePolicyId)

def appSecMalwarePolicy(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecMalwarePolicyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecMalwarePolicy] = 
  ctx.registerResource[AppSecMalwarePolicy, AppSecMalwarePolicyArgs]("akamai:index/appSecMalwarePolicy:AppSecMalwarePolicy", name, args, opts)

