package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecMalwarePolicyAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  action: Output[String],
  configId: Output[Int],
  malwarePolicyId: Output[Int],
  securityPolicyId: Output[String],
  unscannedAction: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecMalwarePolicyAction:
  given outputOps: {} with
    extension(output: Output[AppSecMalwarePolicyAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def action: Output[String] = output.flatMap(_.action)
      def configId: Output[Int] = output.flatMap(_.configId)
      def malwarePolicyId: Output[Int] = output.flatMap(_.malwarePolicyId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def unscannedAction: Output[String] = output.flatMap(_.unscannedAction)

def appSecMalwarePolicyAction(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecMalwarePolicyActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecMalwarePolicyAction] = 
  ctx.registerResource[AppSecMalwarePolicyAction, AppSecMalwarePolicyActionArgs]("akamai:index/appSecMalwarePolicyAction:AppSecMalwarePolicyAction", name, args, opts)

