package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecMalwarePolicyActionArgs private(
  action: Output[String],
  configId: Output[Int],
  malwarePolicyId: Output[Int],
  securityPolicyId: Output[String],
  unscannedAction: Output[String]
) derives ArgsEncoder

object AppSecMalwarePolicyActionArgs:
  def apply(
    action: Input[String],
    configId: Input[Int],
    malwarePolicyId: Input[Int],
    securityPolicyId: Input[String],
    unscannedAction: Input[String]
  )(using Context): AppSecMalwarePolicyActionArgs =
    new AppSecMalwarePolicyActionArgs(
      action = action.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      malwarePolicyId = malwarePolicyId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false),
      unscannedAction = unscannedAction.asOutput(isSecret = false)
    )
