package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecMalwarePolicyActions private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  malwarePolicyActions: Output[String],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecMalwarePolicyActions:
  given outputOps: {} with
    extension(output: Output[AppSecMalwarePolicyActions])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def malwarePolicyActions: Output[String] = output.flatMap(_.malwarePolicyActions)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecMalwarePolicyActions(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecMalwarePolicyActionsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecMalwarePolicyActions] = 
  ctx.registerResource[AppSecMalwarePolicyActions, AppSecMalwarePolicyActionsArgs]("akamai:index/appSecMalwarePolicyActions:AppSecMalwarePolicyActions", name, args, opts)

