package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecMalwarePolicyActionsArgs private(
  configId: Output[Int],
  malwarePolicyActions: Output[String],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecMalwarePolicyActionsArgs:
  def apply(
    configId: Input[Int],
    malwarePolicyActions: Input[String],
    securityPolicyId: Input[String]
  )(using Context): AppSecMalwarePolicyActionsArgs =
    new AppSecMalwarePolicyActionsArgs(
      configId = configId.asOutput(isSecret = false),
      malwarePolicyActions = malwarePolicyActions.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
