package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecMalwarePolicyArgs private(
  configId: Output[Int],
  malwarePolicy: Output[String]
) derives ArgsEncoder

object AppSecMalwarePolicyArgs:
  def apply(
    configId: Input[Int],
    malwarePolicy: Input[String]
  )(using Context): AppSecMalwarePolicyArgs =
    new AppSecMalwarePolicyArgs(
      configId = configId.asOutput(isSecret = false),
      malwarePolicy = malwarePolicy.asOutput(isSecret = false)
    )
