package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecMatchTarget private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  matchTarget: Output[String],
  matchTargetId: Output[Int]
) extends CustomResource derives ResourceDecoder

object AppSecMatchTarget:
  given outputOps: {} with
    extension(output: Output[AppSecMatchTarget])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def matchTarget: Output[String] = output.flatMap(_.matchTarget)
      def matchTargetId: Output[Int] = output.flatMap(_.matchTargetId)

def appSecMatchTarget(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecMatchTargetArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecMatchTarget] = 
  ctx.registerResource[AppSecMatchTarget, AppSecMatchTargetArgs]("akamai:index/appSecMatchTarget:AppSecMatchTarget", name, args, opts)

