package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecMatchTargetArgs private(
  configId: Output[Int],
  matchTarget: Output[String]
) derives ArgsEncoder

object AppSecMatchTargetArgs:
  def apply(
    configId: Input[Int],
    matchTarget: Input[String]
  )(using Context): AppSecMatchTargetArgs =
    new AppSecMatchTargetArgs(
      configId = configId.asOutput(isSecret = false),
      matchTarget = matchTarget.asOutput(isSecret = false)
    )
