package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecMatchTargetSequence private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  matchTargetSequence: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppSecMatchTargetSequence:
  given outputOps: {} with
    extension(output: Output[AppSecMatchTargetSequence])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def matchTargetSequence: Output[Option[String]] = output.flatMap(_.matchTargetSequence)

def appSecMatchTargetSequence(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecMatchTargetSequenceArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecMatchTargetSequence] = 
  ctx.registerResource[AppSecMatchTargetSequence, AppSecMatchTargetSequenceArgs]("akamai:index/appSecMatchTargetSequence:AppSecMatchTargetSequence", name, args, opts)

