package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecMatchTargetSequenceArgs private(
  configId: Output[Int],
  matchTargetSequence: Output[Option[String]]
) derives ArgsEncoder

object AppSecMatchTargetSequenceArgs:
  def apply(
    configId: Input[Int],
    matchTargetSequence: Input.Optional[String] = None
  )(using Context): AppSecMatchTargetSequenceArgs =
    new AppSecMatchTargetSequenceArgs(
      configId = configId.asOutput(isSecret = false),
      matchTargetSequence = matchTargetSequence.asOptionOutput(isSecret = false)
    )
