package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecPenaltyBox private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  penaltyBoxAction: Output[String],
  penaltyBoxProtection: Output[Boolean],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecPenaltyBox:
  given outputOps: {} with
    extension(output: Output[AppSecPenaltyBox])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def penaltyBoxAction: Output[String] = output.flatMap(_.penaltyBoxAction)
      def penaltyBoxProtection: Output[Boolean] = output.flatMap(_.penaltyBoxProtection)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecPenaltyBox(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecPenaltyBoxArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecPenaltyBox] = 
  ctx.registerResource[AppSecPenaltyBox, AppSecPenaltyBoxArgs]("akamai:index/appSecPenaltyBox:AppSecPenaltyBox", name, args, opts)

