package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecPenaltyBoxArgs private(
  configId: Output[Int],
  penaltyBoxAction: Output[String],
  penaltyBoxProtection: Output[Boolean],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecPenaltyBoxArgs:
  def apply(
    configId: Input[Int],
    penaltyBoxAction: Input[String],
    penaltyBoxProtection: Input[Boolean],
    securityPolicyId: Input[String]
  )(using Context): AppSecPenaltyBoxArgs =
    new AppSecPenaltyBoxArgs(
      configId = configId.asOutput(isSecret = false),
      penaltyBoxAction = penaltyBoxAction.asOutput(isSecret = false),
      penaltyBoxProtection = penaltyBoxProtection.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
