package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecRatePolicy private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  ratePolicy: Output[String],
  ratePolicyId: Output[Int]
) extends CustomResource derives ResourceDecoder

object AppSecRatePolicy:
  given outputOps: {} with
    extension(output: Output[AppSecRatePolicy])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def ratePolicy: Output[String] = output.flatMap(_.ratePolicy)
      def ratePolicyId: Output[Int] = output.flatMap(_.ratePolicyId)

def appSecRatePolicy(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecRatePolicyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecRatePolicy] = 
  ctx.registerResource[AppSecRatePolicy, AppSecRatePolicyArgs]("akamai:index/appSecRatePolicy:AppSecRatePolicy", name, args, opts)

