package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecRatePolicyAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  ipv4Action: Output[String],
  ipv6Action: Output[String],
  ratePolicyId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecRatePolicyAction:
  given outputOps: {} with
    extension(output: Output[AppSecRatePolicyAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def ipv4Action: Output[String] = output.flatMap(_.ipv4Action)
      def ipv6Action: Output[String] = output.flatMap(_.ipv6Action)
      def ratePolicyId: Output[Int] = output.flatMap(_.ratePolicyId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecRatePolicyAction(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecRatePolicyActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecRatePolicyAction] = 
  ctx.registerResource[AppSecRatePolicyAction, AppSecRatePolicyActionArgs]("akamai:index/appSecRatePolicyAction:AppSecRatePolicyAction", name, args, opts)

