package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecRatePolicyActionArgs private(
  configId: Output[Int],
  ipv4Action: Output[String],
  ipv6Action: Output[String],
  ratePolicyId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecRatePolicyActionArgs:
  def apply(
    configId: Input[Int],
    ipv4Action: Input[String],
    ipv6Action: Input[String],
    ratePolicyId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecRatePolicyActionArgs =
    new AppSecRatePolicyActionArgs(
      configId = configId.asOutput(isSecret = false),
      ipv4Action = ipv4Action.asOutput(isSecret = false),
      ipv6Action = ipv6Action.asOutput(isSecret = false),
      ratePolicyId = ratePolicyId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
