package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecRatePolicyArgs private(
  configId: Output[Int],
  ratePolicy: Output[String]
) derives ArgsEncoder

object AppSecRatePolicyArgs:
  def apply(
    configId: Input[Int],
    ratePolicy: Input[String]
  )(using Context): AppSecRatePolicyArgs =
    new AppSecRatePolicyArgs(
      configId = configId.asOutput(isSecret = false),
      ratePolicy = ratePolicy.asOutput(isSecret = false)
    )
