package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecRateProtectionArgs private(
  configId: Output[Int],
  enabled: Output[Boolean],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecRateProtectionArgs:
  def apply(
    configId: Input[Int],
    enabled: Input[Boolean],
    securityPolicyId: Input[String]
  )(using Context): AppSecRateProtectionArgs =
    new AppSecRateProtectionArgs(
      configId = configId.asOutput(isSecret = false),
      enabled = enabled.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
