package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecReputationProfile private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  reputationProfile: Output[String],
  reputationProfileId: Output[Int]
) extends CustomResource derives ResourceDecoder

object AppSecReputationProfile:
  given outputOps: {} with
    extension(output: Output[AppSecReputationProfile])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def reputationProfile: Output[String] = output.flatMap(_.reputationProfile)
      def reputationProfileId: Output[Int] = output.flatMap(_.reputationProfileId)

def appSecReputationProfile(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecReputationProfileArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecReputationProfile] = 
  ctx.registerResource[AppSecReputationProfile, AppSecReputationProfileArgs]("akamai:index/appSecReputationProfile:AppSecReputationProfile", name, args, opts)

