package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecReputationProfileAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  action: Output[String],
  configId: Output[Int],
  reputationProfileId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecReputationProfileAction:
  given outputOps: {} with
    extension(output: Output[AppSecReputationProfileAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def action: Output[String] = output.flatMap(_.action)
      def configId: Output[Int] = output.flatMap(_.configId)
      def reputationProfileId: Output[Int] = output.flatMap(_.reputationProfileId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecReputationProfileAction(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecReputationProfileActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecReputationProfileAction] = 
  ctx.registerResource[AppSecReputationProfileAction, AppSecReputationProfileActionArgs]("akamai:index/appSecReputationProfileAction:AppSecReputationProfileAction", name, args, opts)

