package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecReputationProfileActionArgs private(
  action: Output[String],
  configId: Output[Int],
  reputationProfileId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecReputationProfileActionArgs:
  def apply(
    action: Input[String],
    configId: Input[Int],
    reputationProfileId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecReputationProfileActionArgs =
    new AppSecReputationProfileActionArgs(
      action = action.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      reputationProfileId = reputationProfileId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
