package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecReputationProfileAnalysis private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  forwardSharedIpToHttpHeaderSiem: Output[Boolean],
  forwardToHttpHeader: Output[Boolean],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecReputationProfileAnalysis:
  given outputOps: {} with
    extension(output: Output[AppSecReputationProfileAnalysis])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def forwardSharedIpToHttpHeaderSiem: Output[Boolean] = output.flatMap(_.forwardSharedIpToHttpHeaderSiem)
      def forwardToHttpHeader: Output[Boolean] = output.flatMap(_.forwardToHttpHeader)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecReputationProfileAnalysis(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecReputationProfileAnalysisArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecReputationProfileAnalysis] = 
  ctx.registerResource[AppSecReputationProfileAnalysis, AppSecReputationProfileAnalysisArgs]("akamai:index/appSecReputationProfileAnalysis:AppSecReputationProfileAnalysis", name, args, opts)

