package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecReputationProfileAnalysisArgs private(
  configId: Output[Int],
  forwardSharedIpToHttpHeaderSiem: Output[Boolean],
  forwardToHttpHeader: Output[Boolean],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecReputationProfileAnalysisArgs:
  def apply(
    configId: Input[Int],
    forwardSharedIpToHttpHeaderSiem: Input[Boolean],
    forwardToHttpHeader: Input[Boolean],
    securityPolicyId: Input[String]
  )(using Context): AppSecReputationProfileAnalysisArgs =
    new AppSecReputationProfileAnalysisArgs(
      configId = configId.asOutput(isSecret = false),
      forwardSharedIpToHttpHeaderSiem = forwardSharedIpToHttpHeaderSiem.asOutput(isSecret = false),
      forwardToHttpHeader = forwardToHttpHeader.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
