package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecReputationProfileArgs private(
  configId: Output[Int],
  reputationProfile: Output[String]
) derives ArgsEncoder

object AppSecReputationProfileArgs:
  def apply(
    configId: Input[Int],
    reputationProfile: Input[String]
  )(using Context): AppSecReputationProfileArgs =
    new AppSecReputationProfileArgs(
      configId = configId.asOutput(isSecret = false),
      reputationProfile = reputationProfile.asOutput(isSecret = false)
    )
