package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecRule private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  conditionException: Output[Option[String]],
  configId: Output[Int],
  ruleAction: Output[String],
  ruleId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecRule:
  given outputOps: {} with
    extension(output: Output[AppSecRule])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def conditionException: Output[Option[String]] = output.flatMap(_.conditionException)
      def configId: Output[Int] = output.flatMap(_.configId)
      def ruleAction: Output[String] = output.flatMap(_.ruleAction)
      def ruleId: Output[Int] = output.flatMap(_.ruleId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecRule(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecRuleArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecRule] = 
  ctx.registerResource[AppSecRule, AppSecRuleArgs]("akamai:index/appSecRule:AppSecRule", name, args, opts)

